<!---
Please read this!

This template is for reporting a security vulnerability about GitLab or 
GitLab.com

Strongly consider reporting via https://hackerone.com/gitlab, as 
HackerOne is our preferred disclosure platform.

See also:

- https://about.gitlab.com/security/disclosure/
- https://about.gitlab.com/handbook/engineering/security/#creating-new-security-issues
- https://about.gitlab.com/handbook/engineering/security/#engaging-the-security-on-call

--->

⚠ Please read the [process](https://gitlab.com/gitlab-org/release/docs/-/blob/master/general/security/engineer.md) on how to fix security issues before starting to work on the issue. Vulnerabilities must be fixed in a security mirror.

### Summary

<!-- Summarize the bug encountered concisely. -->

### Steps to reproduce

<!-- Describe how one can reproduce the issue - this is very important. Please use an ordered list. -->

### Example Project

<!-- If possible, please create an example project here on GitLab.com that exhibits the problematic 
behavior, and link to it here in the bug report. If you are using an older version of GitLab, this 
will also determine whether the bug is fixed in a more recent version. -->

### What is the current *bug* behavior?

<!-- Describe what actually happens. -->

### What is the expected *correct* behavior?

<!-- Describe what you should see instead. -->

### Relevant logs and/or screenshots

<!-- Paste any relevant logs - please use code blocks (```) to format console output, logs, and code
 as it's tough to read otherwise. -->

### Output of checks

<!-- If you are reporting a bug on GitLab.com, write: This bug happens on GitLab.com -->

#### Results of GitLab environment info

<!--  Input any relevant GitLab environment information if needed. -->

<details>
<summary>Expand for output related to GitLab environment info</summary>

<pre>

(For installations with omnibus-gitlab package run and paste the output of:
`sudo gitlab-rake gitlab:env:info`)

(For installations from source run and paste the output of:
`sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production`)

</pre>
</details>

#### Results of GitLab application Check

<!--  Input any relevant GitLab application check information if needed. -->

<details>
<summary>Expand for output related to the GitLab application check</summary>
<pre>

(For installations with omnibus-gitlab package run and paste the output of:
`sudo gitlab-rake gitlab:check SANITIZE=true`)

(For installations from source run and paste the output of:
`sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production SANITIZE=true`)

(we will only investigate if the tests are passing)

</pre>
</details>

### Possible fixes

<!-- If you can, link to the line of code that might be responsible for the problem. -->


---

<!-- Do not edit past here unless you are certain of the impact -->

cc @gitlab-com/gl-security/product-security/psirt-group

/label ~"type::bug" ~"bug::vulnerability"
/confidential
